//
// Copyright (c) 2002
// Ronald Kevin Burton
//
// Z poniszym kodem nie jest zwizana adna gwarancja poprawnoci dziaania.
// Program zosta doczony do ksiki ".NET CLR. Ksiga eksperta" w celu
// ilustracji koncepcji i zasad przedstawionych w tej ksice. Program moe by 
// uywany na wasne ryzyko.
//
// Przyznaje si prawo do uycia lub kopiowania tego oprogramowania do dowolnego celu
// bez koniecznoci ponoszenia adnych opat pod warunkiem, e powysze uwagi zostan 
// zachowane we wszystkich kopiach. Przyznaje si take prawo do modyfikacji kodu
// i dystrybucji zmodyfikowanego kodu pod warunkiem zachowania powyszych uwag
// oraz doczenia informacji mwicej o modyfikacji kodu.
//
// 
using System;
using System.ComponentModel;
using System.Globalization;

namespace FrameworkLibraries
{
	[TypeConverter(typeof(ComplexConverter))]
	public class Complex
	{
		private double re;
		private double im;
		public Complex(double re, double im)
		{
			this.re = re;
			this.im = im;
		}
		public double Real
		{
			get
			{
				return re;
			}
			set
			{
				re = value;
			}
		}
		public double Imaginary
		{
			get
			{
				return im;
			}
			set
			{
				im = value;
			}
		}
	}
	public class ComplexConverter : TypeConverter
	{
		// Zastpienie metody CanConvertFrom z TypeConverter.
		// Interfejs ITypeDescriptorContext zapewnia kontekst konwersji.
		// Ten interfejs jest zwykle uywany w czasie projektowania
		// w celu zapewnienia informacji o kontenerze.
		public override bool CanConvertFrom(ITypeDescriptorContext context, 
			Type sourceType) 
		{
			if (sourceType == typeof(string)) 
			{
				return true;
			}
			return base.CanConvertFrom(context, sourceType);
		}
		// Zastpienie metody ConvertFrom z TypeConverter.
		public override object ConvertFrom(ITypeDescriptorContext context, 
			CultureInfo culture, object value) 
		{
			if (value is string) 
			{
				string[] v = ((string)value).Split(new char[] {','});
				return new Complex(double.Parse(v[0]), double.Parse(v[1]));
			}
			return base.ConvertFrom(context, culture, value);
		}
		// Zastpienie metody ConvertTo z TypeConverter.
		public override object ConvertTo(ITypeDescriptorContext context, 
			CultureInfo culture, object value, Type destinationType) 
		{  
			if (destinationType == typeof(string)) 
			{
				return ((Complex)value).Real + "," + ((Complex)value).Imaginary;
			}
			return base.ConvertTo(context, culture, value, destinationType);
		}
	}
	public class VersionMain 
	{
		static void Main(string [] args)
		{
			Complex c = (Complex)TypeDescriptor.GetConverter(typeof(Complex)).ConvertFromString("1.0,2.0");
			string ds = (string)TypeDescriptor.GetConverter(c).ConvertToString(c);
			Console.WriteLine("{0},{1} <-> {2}", c.Real, c.Imaginary, ds);
		}
	}
}